/***************************************************************
 *                    simula+@metz.ensam.fr                    *
 *	             GNU/linux version 2.0.0                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright  2006,2007,2008 COLLARD Christophe
 * copyright  2006,2007,2008 Laboratoire de Physique et Mcanique des Matriaux (LPMM - UMR 7554)
 * copyright  2006,2007 Laboratoire de Mathmatiques et ses Applications de Valenciennes (LAMAV - EA 4015)
 ***************************************************************/

/*
    cubic tensors-tests belongs to Materials Object Libraries (MateriOL++)
    MateriOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for the type cubic tensors test
#endif

#if !defined(__CUBIC_ELASTICITY_TENSORS_TEST_H)
#define __CUBIC_ELASTICITY_TENSORS_TEST_H


#if !defined (__IOSTREAM_H)
#include <iostream>
#endif

#if !defined(__STDIO_H)
#include <stdio.h>
#endif

#if !defined(__STDLIB_H)
#include <stdlib.h>
#endif

#if !defined(__PARAMETERS_H)
#include "parameters.h"
#endif

#if !defined(__MATRIX_H)
#include"MOL++/matrix.h"
#endif

#if !defined(___TENSOR4_H)
#include"MOL++/tensors4.h"
#endif

#if !defined(__CONVERSION_TOOLS_H)
#include"MOL++/conversion tools.h"
#endif

#if !defined(__ISOTROPIC_ELASTICITY_TENSORS_H)
#include"MateriOL++/isotropic elasticity tensors.h"
#endif

#if !defined(__CUBIC_TENSORS_H)
#include"MateriOL++/cubic tensors.h"
#endif

#if !defined(__CUBIC_ELASTICITY_TENSORS_H)
#include"MateriOL++/cubic elasticity tensors.h"
#endif

#if !defined(__AFFICHE_h)
#include "tests/affiche.h"
#endif

using namespace materiol;


//===========================================
int test_cubic_elasticity_tensor (int detail)
//===========================================
{
  bool result = true;

  long double lambda=60000, mu=40000;
  isotropic_elasticity_tensor<long double> C;
  C.Lame(lambda);
  C.Shear(mu);
  cubic_elasticity_tensor<long double> Czr("Zr");
  Czr.Young(C.Young());
  Czr.Poisson(C.Poisson());
  Czr.Shear(C.Shear());
  if (detail) affiche ("cubic elasticity tensor for isotropic materials", C==Czr);
  else result *= (C==Czr);

  tensor4<long double> inv = matrix2symtensor(gauss(symtensor2matrix(Czr)));
  if (detail) affiche ("inv", C.inv()==Czr.inv() && Czr.inv()==inv);
  else result *= (C.inv()==Czr.inv() && Czr.inv()==inv);

  long double E = 68000; // Young
  long double nu = 0.34; // Poisson
  mu = 33000; // shear
  Czr.Young(E);
  Czr.Poisson(nu);
  Czr.Shear(mu);
  if (detail) affiche ("material's constants", Czr.Young()==E && Czr.Shear()==mu && Czr.Poisson()==nu);
  else result *= (Czr.Young()==E && Czr.Shear()==mu && Czr.Poisson()==nu);

  cubic_tensor<long double> TC (Czr(1,1,1,1), Czr(1,2,1,2), Czr(1,1,2,2));
  cubic_elasticity_tensor<long double> TCE(TC);
  if (detail) affiche ("copy constructor", relative_error(TCE.Young(),E) && relative_error(TCE.Shear(),mu) && relative_error(TCE.Poisson(),nu));
  else result *= (relative_error(TCE.Young(),E) && relative_error(TCE.Shear(),mu) && relative_error(TCE.Poisson(),nu));

  tensor2<long double> stress(3), strain(3);
  tensor4<long double> C4 (3);
  C4 = Czr;
  for (int i=1; i<=3; i++)
    for (int j=1; j<=3; j++)
      { strain (i,j) = 7.231*(i + j);
	for (int k=1; k<=3; k++)
	  for (int l=1; l<=3; l++)
	    C4(i,j,k,l) = 3*i -7*j + 1.11*k - 13.17*l;
      }
  for (int i=1; i<=3; i++)
    for (int j=1; j<=3; j++)
      for (int k=1; k<=3; k++)
	for (int l=1; l<=3; l++)
	  C4(i,j,k,l) = C4(j,i,k,l) = C4(i,j,l,k) = C4(j,i,l,k) = C4(k,l,i,j) = C4(l,k,i,j) = C4(k,l,j,i) = C4(l,k,j,i);
  C4 = Czr;
  matrix<long double> M(6,6);
  M(1,1) = C4(1,1,1,1);
  M(1,2) = M(2,1) = C4(1,1,2,2);
  M(1,3) = M(3,1) = C4(1,1,3,3);
  M(1,4) = M(4,1) = C4(1,1,1,2);
  M(1,5) = M(5,1) = C4(1,1,1,3);
  M(1,6) = M(6,1) = C4(1,1,2,3);
  M(2,2) = C4(2,2,2,2);
  M(2,3) = M(3,2) = C4(2,2,3,3);
  M(2,4) = M(4,2) = C4(2,2,1,2);
  M(2,5) = M(5,2) = C4(2,2,1,3);
  M(2,6) = M(6,2) = C4(2,2,2,3);
  M(3,3) = C4(3,3,3,3);
  M(3,4) = M(4,3) = C4(3,3,1,2);
  M(3,5) = M(5,3) = C4(3,3,1,3);
  M(3,6) = M(6,3) = C4(3,3,2,3);
  M(4,4) = C4(1,2,1,2);
  M(4,5) = M(5,4) = C4(1,2,1,3);
  M(4,6) = M(6,4) = C4(1,2,2,3);
  M(5,5) = C4(1,3,1,3);
  M(5,6) = M(6,5) = C4(1,3,2,3);
  M(6,6) = C4(2,3,2,3);
  vector<long double> stress2, strain2(6);
  strain2[1] = strain(1,1);
  strain2[2] = strain(2,2);
  strain2[3] = strain(3,3);
  strain2[4] = 2 * strain(1,2);
  strain2[5] = 2 * strain(1,3);
  strain2[6] = 2 * strain(2,3);
  stress = (C4||strain);
  stress2 = M * strain2;
  tensor2<long double> Tstress2(3);
  Tstress2(1,1) = stress2[1];
  Tstress2(2,2) = stress2[2];
  Tstress2(3,3) = stress2[3];
  Tstress2(1,2) = Tstress2(2,1) = stress2[4];
  Tstress2(1,3) = Tstress2(3,1) = stress2[5];
  Tstress2(2,3) = Tstress2(3,2) = stress2[6];
  if (detail) affiche ("cubic elasticity tensor", stress==Tstress2);
  else result *= (stress==Tstress2);

  tensor4<long double> T;
  T = Czr;
  cubic_elasticity_tensor<long double> Cn;
  Cn = cubic_elasticity_tensor<long double> (T);
  if (detail) affiche("cast conversion tensor4 -> cubic_tensor", Czr == Cn);
  else result *= (Czr == Cn);

  vector<long double> v(3);
  v[1] = (1-nu)*E/(1+nu)/(1-2*nu);
  v[2] = mu;
  v[3] = v[1] * nu / (1-nu);
  if (detail) affiche ("elastic constants", Czr.elastic_constants() == v);
  else result *= (Czr.elastic_constants() == v);

  strain = (matrix2symtensor(gauss(symtensor2matrix(C4))) || stress);
  strain2 = gauss(M) * stress2;
  tensor2<long double> Tstrain2(3);
  Tstrain2(1,1) = strain2[1];
  Tstrain2(2,2) = strain2[2];
  Tstrain2(3,3) = strain2[3];
  Tstrain2(1,2) = Tstrain2(2,1) = .5 * strain2[4];
  Tstrain2(1,3) = Tstrain2(3,1) = .5 * strain2[5];
  Tstrain2(2,3) = Tstrain2(3,2) = .5 * strain2[6];
  if (detail) affiche ("inv", strain==Tstrain2 && Czr.inv()==matrix2symtensor(gauss(symtensor2matrix(C4))));
  else result *= (strain==Tstrain2 && Czr.inv()==matrix2symtensor(gauss(symtensor2matrix(C4))));

  cout << endl;

  cout << "============================================================== \n";
  if (result) cout<< "              cubic elasticity tensor test passed \n";
  else cout << "              cubic elasticity tensor test failed \n";
  cout << "============================================================== \n";

  return result;
}


#endif
